import argparse
from http.server import HTTPServer, SimpleHTTPRequestHandler

parser = argparse.ArgumentParser(
    prog="Simple HTTP Server",
    description="Serves static files using Python3 Simple HTTP module",
)
parser.add_argument("-d", "--directory", required=True)
args = parser.parse_args()

PORT = 8000
DIRECTORY = args.directory


class CORSRequestHandler(SimpleHTTPRequestHandler):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, directory=DIRECTORY, **kwargs)

    def end_headers(self):
        self.send_header("Access-Control-Allow-Origin", "*")
        self.send_header("Access-Control-Allow-Methods", "GET")
        self.send_header("Cache-Control", "no-store, no-cache, must-revalidate")
        return super(CORSRequestHandler, self).end_headers()


with HTTPServer(("", PORT), CORSRequestHandler) as httpd:
    print("serving at port:", PORT)
    httpd.serve_forever()